<?php
if (! defined( 'ABSPATH' )) exit;
function domaindata($url) {
    preg_match("/^(https|http|ftp):\/\/(.*?)\//", "$url/" , $matches);
    $parts = explode(".", $matches[2]);
    $tld = array_pop($parts);
    $host = array_pop($parts);
    if ( strlen($tld) == 2 && strlen($host) <= 3 ) {
        $tld = "$host.$tld";
        $host = array_pop($parts);
    }

    return array(
        'protocol' => $matches[1],
        'subdomain' => implode(".", $parts),
        'domain' => "$host.$tld",
        'host'=>$host,'tld'=>$tld
    );
}

function Vindicta_EX_AMP() { ob_start("Vindicta_AMP_EX"); }

$staticdomain = domaindata(get_site_url())['domain'];
$staticprotokol = domaindata(get_site_url())['protocol'];
$staticsub = domaindata(get_site_url())['subdomain'];
$statichost = domaindata(get_site_url())['host'];
$statictld = domaindata(get_site_url())['tld'];
$req_uri = $_SERVER['REQUEST_URI'];
$usera = $_SERVER['HTTP_USER_AGENT'];

function tooltip($text_data) {
	return '<span class="vindicta_tips" title="'.$text_data.'">?</span>';
}

$subdomain_name = !empty(get_option("wp_amp_cdn_subdomain_name")) ? get_option("wp_amp_cdn_subdomain_name") : null;

function get_first_img($pid) {
    foreach( get_attached_media( 'image', $pid ) as $key => $val ) {
        return $val->guid;
    }
    return false;
}

function get_first_img_attr($pid) {
    foreach( get_attached_media( 'image', $pid ) as $key => $val ) {
        return wp_get_attachment_image_src( $val->ID );
    }
    return false;
}